#include "DataBox.h"

namespace DataTypes
{

DataBox::DataBox()
{
}

DataBox::DataBox(int bodyid, Vector3f size, Vector3f position,Vector3f rotation,int materialid, float mass, Vector3f linearvelocity, Vector3f angularvelocity): DataBody(bodyid, materialid, mass, linearvelocity, angularvelocity)
{
	this->size = size;
	this->position = position;	
	this->rotation = rotation;
}

DataBox::~DataBox()
{
}

Vector3f DataBox::GetSize()
{
	return size;
}
Vector3f DataBox::GetPosition()
{
	return position;
}

Vector3f DataBox::GetRotation()
{
	return rotation;
}

void DataBox::SetSize(Vector3f value)
{
	this->size = value;
}

void DataBox::SetPosition(Vector3f value)
{
	this->position = value;
}

void DataBox::SetRotation(Vector3f value)
{
	this->rotation = value;
}

string DataBox::ToString()
{
	stringstream id,material, mass;
	id<< this->GetBodyId();
	material<< this->GetMaterialId();
	mass<<this->GetMass();
	string ret ="<Body Type=\"Box\"><Body_id>"+id.str()+"</Body_id><Material>"+ material.str()+"</Material><Mass>"+mass.str()+"</Mass>"+ size.ToString("Size_X","Size_Y","Size_Z")+position.ToString("Position_X","Position_Y","Position_Z")+rotation.ToString("Rotation_X","Rotation_Y","Rotation_Z")+this->GetLinearVelocity().ToString("Linear_Velocity_X","Linear_Velocity_Y","Linear_Velocity_Z")+this->GetAngularVelocity().ToString("Angular_Velocity_X","Angular_Velocity_Y","Angular_Velocity_Z")+"</Body>" ;
	return ret;
}


}
